<?php
	header('Access-Control-Allow-Origin: *');
	require_once 'include/class.user.php';
	$user_home = new USER();

	if (!empty($_GET["action"])) {
		$action = $_GET["action"];
		switch ($action) {
			case 'postScore':
				if (!empty($_POST["userId"])) {
					$userId = $_POST["userId"];
				}
				if (!empty($_POST["leaderboardId"])) {
					$leaderboardId = $_POST["leaderboardId"];
				}
				if (!empty($_POST["hash"])) {
					$hash = $_POST["hash"];
				}
				if (!empty($_POST["score"])) {
					$score = $_POST["score"];
				}
				if (!empty($_POST["name"])) {
					$name = $_POST["name"];
				}
				if (!empty($_POST["lang"])) {
					$lang = $_POST["lang"];
				}

				if (empty($userId) || empty($leaderboardId) || empty($hash) || empty($score) || empty($name) || empty($lang)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					if ($stmt = $user_home->prepareQuery("SELECT token, reverse, name FROM leaderboards WHERE id = ?")) {
						$stmt->bind_param('i', $leaderboardId);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($leaderboardToken, $leaderboardReverse, $leaderboardName);
						$stmt->fetch();
						
						if ($stmt->num_rows == 1) {
						
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The leaderboard with this id does not exist";
									break;
								case "fa":
									$return["data"] = "جدول امتیازی با شناسه موردنظر وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
					}
					$newHash = hash('sha512', $userId.$leaderboardId.$leaderboardToken.$score);
					if (strtolower($hash) != $newHash) {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "Token sent is wrong";
								break;
							case "fa":
								$return["data"] = "توکن ارسالي اشتباه است";
								break;
						}
						echo json_encode($return);
						return;
					}
					
					switch($leaderboardReverse) {
						case 1:
							if (record_exists ( "{$leaderboardToken}_scores", 'user_id', $userId, 'table_id', $leaderboardId )){
								$sql = "UPDATE {$leaderboardToken}_scores SET name='$name', add_datetime=NOW() ,score = if ($score<score, $score, score) WHERE user_id=? AND table_id=?";
							} else {
								$sql = "INSERT INTO {$leaderboardToken}_scores(user_id, table_id, score, name) VALUES(?, ? ,$score ,'$name')";
							}
							break;
						case 0:
							if (record_exists ( "{$leaderboardToken}_scores", 'user_id', $userId, 'table_id', $leaderboardId )){
								$sql = "UPDATE {$leaderboardToken}_scores SET name='$name', add_datetime=NOW() ,score = if ($score>score, $score, score) WHERE user_id=? AND table_id=?";
							} else {
								$sql = "INSERT INTO {$leaderboardToken}_scores(user_id, table_id, score, name) VALUES(?, ? ,$score ,'$name')";
							}
							break;
					}
					
					if ($stmt = $user_home->prepareQuery($sql)) {
						$stmt->bind_param('si', $userId, $leaderboardId);

						if ($stmt->execute()) {
							$return["status"] = "success";
							switch ($lang) {
								case "en":
									$return["data"] = "Score sent successfully";
									break;
								case "fa":
									$return["data"] = "امتیاز با موفقیت ارسال شد";
									break;
							}
							echo json_encode($return);
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "An error occurred while sending score";
									break;
								case "fa":
									$return["data"] = "خطایی در ارسال امتیاز رخ داده است";
									break;
							}
							echo json_encode($return);
						}
					} else {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "An error occurred while sending score";
								break;
							case "fa":
								$return["data"] = "خطایی در ارسال امتیاز رخ داده است";
								break;
						}
						echo json_encode($return);
					}
				}
				break;
			case 'postHit':
				if (!empty($_POST["userId"])) {
					$userId = $_POST["userId"];
				}
				if (!empty($_POST["achievementId"])) {
					$achievementId = $_POST["achievementId"];
				}
				if (!empty($_POST["lang"])) {
					$lang = $_POST["lang"];
				}
				if (!empty($_POST["hash"])) {
					$hash = $_POST["hash"];
				}

				if (empty($userId) || empty($achievementId) || empty($lang) || empty($hash)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					if ($stmt = $user_home->prepareQuery("SELECT name, token FROM achievements WHERE id = ?")) {
						$stmt->bind_param('i', $achievementId);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($achievementName, $achievementToken);
						$stmt->fetch();
						
						if ($stmt->num_rows != 1) {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The achievement with this id does not exist";
									break;
								case "fa":
									$return["data"] = "دستاوردی با شناسه موردنظر وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
					}
					$newHash = hash('sha512', $userId.$achievementId.$achievementToken);
					if (strtolower($hash) != $newHash) {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "Token sent is wrong";
								break;
							case "fa":
								$return["data"] = "توکن ارسالي اشتباه است";
								break;
						}
						echo json_encode($return);
						return;
					}
					
					if (record_exists ( "{$achievementToken}_hits", 'user_id', $userId, 'achievement_id', $achievementId )){
						$sql = "UPDATE {$achievementToken}_hits SET add_datetime=NOW() WHERE user_id=? AND achievement_id=?";
					} else {
						$sql = "INSERT INTO {$achievementToken}_hits(user_id, achievement_id) VALUES(?, ?)";
					}
					
					if ($stmt = $user_home->prepareQuery($sql)) {
						$stmt->bind_param('si', $userId, $achievementId);

						if ($stmt->execute()) {
							$return["status"] = "success";
							switch ($lang) {
								case "en":
									$return["data"] = "Successfuly sent hit to achievement";
									break;
								case "fa":
									$return["data"] = "دستیابی با موفقیت ارسال شد";
									break;
							}
							echo json_encode($return);
							return;
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "An error occurred while submiting hit";
									break;
								case "fa":
									$return["data"] = "خطایی در ارسال دستیابی رخ داده است";
									break;
							}
							echo json_encode($return);
							return;
						}
					} else {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "An error occurred while submiting hit";
								break;
							case "fa":
								$return["data"] = "خطایی در ارسال دستیابی رخ داده است";
								break;
						}
						echo json_encode($return);
					}
				}
				break;
		}
	}
	
	function record_exists ($table, $column1, $value1, $column2, $value2) {
		$user_home = new USER();
		$stmt = $user_home->prepareQuery("SELECT * FROM $table WHERE $column1=? AND $column2=?");
		$stmt->bind_param('si', $value1, $value2);
		$stmt->execute();
		$stmt->store_result();
		$stmt->fetch();
		if ($stmt->num_rows > 0) {
			return true;
		} else {
			return false;
		}
	}
?>